;==============================================
;= LADY'S GARDEN 2001 Reel Media Productions =
;= programmed by Paul Leischow  Sept.15 /2001 =
;==============================================

If InitSprite(99) = 0 Or InitKeyboard() = 0
  MessageRequester("Error", "Can't open DirectX 7 or later", 0)
  End
EndIf
If InitSound(10) = 0 
  MessageRequester("Error", "Can't open DirectX 7 Or Sound Card is not present", 0)
  End
EndIf
;========SYSTEM SPECS ARE OK


Procedure text(txtx.l,txty.l,txt.s)                  ;x/y screen coordinates are send along with a text string
  For tmp=1 To len(txt)                              ;loop for the length of the string   
    txtasc=asc(mid(txt,tmp,1))                        ;get the ASCII value of each character in the string
    If txtasc<>32                                     ;if its not a space, display the sprite on the screen
      DisplayTransparentSprite(txtasc+5,txtx,txty)
    EndIf
    txtx=txtx+16                                      ;move the width of the sprite so we can display the next one
  Next
  txty=txty+25                                        ;move down to the next line
EndProcedure

Structure ladybug                                    ;create a structure to hold all Lady's info
  lpx.w                                               ;x position of Lady
  lpy.w                                               ;y position of Lady
  lpxpos.w                                            ;x position in the lookup table
  lpypos.w                                            ;y position in the lookup table
  ldir.w                                              ;direction Lady is moving
  lmove.w                                             ;counter for movement to next tile
  lx.w                                                ;x speed of Lady
  ly.w                                                ;y speed of Lady
EndStructure

Global txtx.l                                        ;x position of text
Global txty.l                                        ;y position of text
Global txt.s                                         ;string that hold text
#mazewidth=12                                         ;width of maze (12 tiles)
#mazeheight=13                                        ;hight of maze (13 tiles)
level=1                                               ;current game level
bugs=1                                                ;number of Lady bugs in the maze
frmbee=0                                              ;what frame of Bee to display
score.l=0                                             ;current score

Dim lady.ladybug(4)                                   ;set up 4 Lady bugs
Dim maze(#mazewidth,#mazeheight)                      ;set up an array to hold maze tiles
Dim track(#mazewidth,#mazeheight)                     ;set up an array to hold Lady movement data

If OpenScreen(640,480,16,"Lady's Garden")             ;open a 640x480 graphic window
  LoadSprite(1,"data\bush1.bmp",0)                    ;load all the game sprites
  LoadSprite(2,"data\bush2.bmp",0)
  LoadSprite(3,"data\black.bmp",0)
  LoadSprite(4,"data\clear.bmp",0)
  LoadSprite(5,"data\flower.bmp",0)
  LoadSprite(6,"data\ladyl.bmp",0)
  LoadSprite(7,"data\ladyr.bmp",0)
  LoadSprite(8,"data\ladyu.bmp",0)
  LoadSprite(9,"data\ladyd.bmp",0)
  LoadSprite(10,"data\level.bmp",0)
  LoadSprite(11,"data\over.bmp",0)
  LoadSprite(12,"data\diz1.bmp",0)
  LoadSprite(13,"data\diz2.bmp",0)
  LoadSprite(14,"data\diz3.bmp",0)    
  For tmp=20 To 59
    LoadSprite(tmp,"data\bee"+str(tmp)+".bmp",0)      ;load all the Bee sprites
  Next
  For tmp=60 To 69
    LoadSprite(tmp,"data\num"+str(tmp)+".bmp",0)      ;load all the number sprites for score
  Next
  For tmp=70 To 95
    LoadSprite(tmp,"data\a"+str(tmp)+".bmp",0)        ;load all the alphabet sprites for text
  Next  
  LoadSound(1,"data\blip.wav")                        ;load all the sound effects
  LoadSound(2,"data\catch.wav")
  LoadSound(3,"data\level.wav")
  LoadSound(4,"data\intro.wav")


;===========================MAINLOOP
mainloop:

  Gosub init_data                                      ;initialize game data / all starting positions
  Gosub load_maze                                      ;load the first maze
  Gosub load_data                                      ;load the first movement table
  
  If level=1 And bugs=1                                ;if we're on level 1 and there is 1 Lady bug
    hold=0
    While hold=0                                       ;display instructions until space is pressed
      DisplaySprite(4,0,0)
      text(80,90,"GUIDE BUMBLE THROUGH")
      text(80,115,"THE HEDGE MAZE AND")
      text(80,140,"PICK ALL THE FLOWERS")
      text(80,215,"IF LADY CATCHES YOU")
      text(80,240,"ITS GAME OVER")
      text(130,350,"PRESS SPACEBAR")
      frmbee=frmbee+1
      If frmbee>9:frmbee=0:EndIf                      ;cycle through all 9 frames of Bee flying
      DisplayTransparentSprite(frmbee+50,30,90)        ;display Bee sprite
      DisplayTransparentSprite(8,30,220)               ;display Lady sprite
      FlipBuffers()                                    ;Flip screen buffer into view
      ExamineKeyboard()
      If KeyboardPushed(#PB_Key_Space) Or KeyboardPushed(#PB_Key_Escape):hold=1:EndIf
    Wend
  EndIf 
  PlaySound(4)                                         ;play starting tune
  
  While quit=0
    If flower=0:quit=1:EndIf                          ;loop until all flowers have been collected      
    ExamineKeyboard()
    If KeyboardPushed(#PB_Key_Escape):Gosub draw_credits:End:EndIf   ;if ESC is pressed show credits and end
    If KeyboardPushed(#PB_Key_Left):mm=1:EndIf                        ;check for left/right/up/down arrows keys
    If KeyboardPushed(#PB_Key_Right):mm=2:EndIf
    If KeyboardPushed(#PB_Key_Up):mm=3:EndIf
    If KeyboardPushed(#PB_Key_Down):mm=4:EndIf    
    Select mm
      Case 1 
        If mve=0 And maze(cpxpos-1,cpypos)>2                ;move Bee according to the direction you've selected
         cx=-2:cy=0:cpdir=1:cpxpos=cpxpos-1:mve=32
         Gosub check_flower                                 ;check if you've plucked any flowers along the way
       EndIf
      Case 2 
        If mve=0 And maze(cpxpos+1,cpypos)>2
         cx=2:cy=0:cpdir=3:cpxpos=cpxpos+1:mve=32
         Gosub check_flower
       EndIf
      Case 3 
        If mve=0 And maze(cpxpos,cpypos-1)>2
         cx=0:cy=-2:cpdir=2:cpypos=cpypos-1:mve=32
         Gosub check_flower
       EndIf
      Case 4 
        If mve=0 And maze(cpxpos,cpypos+1)>2
         cx=0:cy=2:cpdir=4:cpypos=cpypos+1:mve=32
         Gosub check_flower
       EndIf      
    EndSelect
    If mve<>0:cpx=cpx+cx:cpy=cpy+cy:mve=mve-2:EndIf

    Gosub move_lady                                        ;Ladybug movement routine and AI
    Gosub draw_board                                       ;draw the maze on the screen
    Gosub draw_bugs                                        ;draw the Lady bugs on the screen
    Gosub set_score                                        ;draw the score on the screen   

    If quit>0 
       If quit=1                                            ;if quit=1 then we've finished the level
          tmpy=480                                          ;place the 'level' sign at the bottom of screen
          PlaySound(3)
          For nextlevel=0 To 190                           
            Gosub draw_board                               ;draw the maze on the screen
            Gosub set_score                                ;draw the score on the screen
            DisplaySprite(10,134,tmpy)                      ;draw the 'level complete' sign
            FlipBuffers()                                   ;flip screen buffer into view
            tmpy=tmpy-3                                     ;move the sign up 3 pixels
          Next
       EndIf
       If quit=2:PlaySound(2):EndIf                       ;if quit=2 then Lady gottcha / play gottcha sound
    EndIf

    FlipBuffers()                                          ;flip screen buffer into view
  Wend  
  Else
  messagerequester("Error","Could Not Initialize 640x480x16 Display",0)
  End
EndIf

If quit=2                                                           ;Lady gottcha
  diz=0                                                             ;current frame of dizzy bee
  Restore level1                                                   ;reset the maze data to load level 1
  For hold=1 To 400                                                 ;hold this screen till we count to 400
    Gosub draw_board                                                ;draw the maze on the screen
    Gosub set_score                                                 ;draw the score on the screen
    Gosub draw_diz                                                  ;draw the dizzy bee on the screen
    DisplaySprite(11,134,110)                                        ;draw the game over sign  
    delay(50)                                                        ;small delay so bee doesn't flap to fast
    ExamineKeyboard()
    If KeyboardPushed(#PB_Key_Space):hold=400:delay(500):EndIf      ;press space to start again
    If KeyboardPushed(#PB_Key_Escape):Gosub draw_credits:End:EndIf ;press ESC to display credits and end 
    flipBuffers()                                                    ;flip screen buffer into view
  Next
  level=0                                                            ;reset all data
  bugs=0
  score=0
EndIf
level=level+1                                  ;advance level
bugs=bugs+1                                    ;add another Lady bug to screen
If bugs>4:bugs=4:EndIf                        ;if we have 4 Lady bugs, then that's enough
If level>4:level=1:Restore level1:EndIf      ;if we've finished level 4 then start over again at level 1
Goto mainloop


;=============SPECIAL ROUTINES
init_data:
  cpx=32*2                                      ;position Bee on the screen
  cpy=32*2                                      ;tiles are 32x32 so we need to multiply maze data by 32
  cpxpos=2                                      ;position Bee in the maze array
  cpypos=2
  cpdir=1
  cpmve=0
  cx=0
  cy=0
  quit=0
  mve=0
  mm=0                                    
  For tmp=1 To 4                                 ;reset data for all 4 Lady bugs
    lady(tmp)\ldir=4
    lady(tmp)\lmove=0
    lady(tmp)\lx=0
    lady(tmp)\ly=0
  Next
  lady(1)\lpx=32*11                              ;place all 4 Lady bugs in their starting positions
  lady(1)\lpy=32*12
  lady(1)\lpxpos=11
  lady(1)\lpypos=12

  lady(2)\lpx=32*11
  lady(2)\lpy=32*6
  lady(2)\lpxpos=11
  lady(2)\lpypos=6

  lady(3)\lpx=32*11
  lady(3)\lpy=32*8
  lady(3)\lpxpos=11
  lady(3)\lpypos=8

  lady(4)\lpx=32*11
  lady(4)\lpy=32*4
  lady(4)\lpxpos=11
  lady(4)\lpypos=4
Return

load_maze:
  For y=1 To #mazeheight                    ;load the maze tile data into an array
    For x=1 To #mazewidth
      Read maze(x,y)    
    Next
  Next
  Read flower                               ;see how many flowers we need to pluck
Return
load_data:
  For y=1 To #mazeheight                    ;load Lady's movement lookup table into an array
    For x=1 To #mazewidth
      Read track(x,y)    
    Next
  Next  
Return

check_flower:                                    
  If maze(cpxpos,cpypos)=5                  ;if we've reached a flower (5)
    maze(cpxpos,cpypos)=3                   ;then change it to a blank (3)
    flower=flower-1                         ;decrement flower counter by 1
    score=score+5                           ;increment score by 5 points
    PlaySound(1)                            ;play the flower plucking sound
  EndIf
Return

set_score:
  tempscore$=str(score)
  If len(tempscore$)=1:newscore$="0000"+tempscore$:EndIf              ;place leading zeros in the score
  If len(tempscore$)=2:newscore$="000"+tempscore$:EndIf
  If len(tempscore$)=3:newscore$="00"+tempscore$:EndIf
  If len(tempscore$)=4:newscore$="0"+tempscore$:EndIf
  If len(tempscore$)=5:newscore$=tempscore$:EndIf
  xscore=448                                                           ;x position to start drawing score
  For tmp=1 To len(newscore$)                                         ;break apart score 1 character at a time
    DisplayTransparentSprite(val(mid(newscore$,tmp,1))+60,xscore,200)  ;and display correct sprite
    xscore=xscore+30                                                   ;move right to draw next character
  Next 
Return

move_lady:
  For bug=1 To bugs                            ;for an explaination of how this all works
    lbx.l=lady(bug)\lpxpos                      ;check out Paul Gerfen's tutorial at
    lby.l=lady(bug)\lpypos                      ;www.openrpgs.com/articles/showarticle.php?article=2001/apr/pacman
    check.l=track(lbx,lby)  
      
    If lady(bug)\lmove=0
      Select check 
        Case 1:If lady(bug)\ldir=2:lady(bug)\ldir=3:Else:lady(bug)\ldir=4:EndIf
        Case 2:If lady(bug)\ldir=3:lady(bug)\ldir=4:Else:lady(bug)\ldir=1:EndIf
        Case 3:If lady(bug)\ldir=4:lady(bug)\ldir=1:Else:lady(bug)\ldir=2:EndIf
        Case 4:If lady(bug)\ldir=1:lady(bug)\ldir=2:Else:lady(bug)\ldir=3:EndIf
      EndSelect
    EndIf

    If lady(bug)\lmove=0 And check=5
       Select lady(bug)\ldir
         Case 3:If cpypos<lady(bug)\lpypos:lady(bug)\ldir=2:Else:lady(bug)\ldir=4:EndIf
         Case 2:If cpxpos<lady(bug)\lpxpos:lady(bug)\ldir=1:Else:lady(bug)\ldir=2:EndIf
         Case 4:If cpypos>lady(bug)\lpypos:lady(bug)\ldir=4:Else:lady(bug)\ldir=1:EndIf
       EndSelect 
    EndIf

    If lady(bug)\lmove=0 And check=6
       Select lady(bug)\ldir
         Case 4:If cpxpos<lady(bug)\lpxpos:lady(bug)\ldir=1:Else:lady(bug)\ldir=3:EndIf
         Case 3:If cpypos<lady(bug)\lpypos:lady(bug)\ldir=2:Else:lady(bug)\ldir=3:EndIf
         Case 1:If cpxpos<lady(bug)\lpxpos:lady(bug)\ldir=1:Else:lady(bug)\ldir=2:EndIf
       EndSelect 
    EndIf

    If lady(bug)\lmove=0 And check=7
     Select lady(bug)\ldir
       Case 4:If cpxpos>lady(bug)\lpxpos:lady(bug)\ldir=3:Else:lady(bug)\ldir=4:EndIf
       Case 1:If cpypos<lady(bug)\lpypos:lady(bug)\ldir=2:Else:lady(bug)\ldir=4:EndIf
       Case 2:If cpypos<lady(bug)\lpypos:lady(bug)\ldir=2:Else:lady(bug)\ldir=3:EndIf
     EndSelect 
    EndIf

    If lady(bug)\lmove=0 And check=8
      Select lady(bug)\ldir
       Case 2:If cpxpos>lady(bug)\lpxpos:lady(bug)\ldir=3:Else:lady(bug)\ldir=1:EndIf
       Case 3:If cpypos>lady(bug)\lpypos:lady(bug)\ldir=4:Else:lady(bug)\ldir=3:EndIf
       Case 1:If cpypos>lady(bug)\lpypos:lady(bug)\ldir=4:Else:lady(bug)\ldir=1:EndIf
     EndSelect 
    EndIf

    Select lady(bug)\ldir
     Case 1:lady(bug)\lx=-1:lady(bug)\ly=0
     Case 2:lady(bug)\lx=0:lady(bug)\ly=-1
     Case 3:lady(bug)\lx=1:lady(bug)\ly=0
     Case 4:lady(bug)\lx=0:lady(bug)\ly=1
    EndSelect 

    If lady(bug)\lmove=0
      lady(bug)\lpxpos=lady(bug)\lpxpos+lady(bug)\lx
      lady(bug)\lpypos=lady(bug)\lpypos+lady(bug)\ly
      lady(bug)\lmove=32
    EndIf

    If lady(bug)\lmove<>0
      lady(bug)\lpx=lady(bug)\lpx+lady(bug)\lx
      lady(bug)\lpy=lady(bug)\lpy+lady(bug)\ly
      lady(bug)\lmove=lady(bug)\lmove-1
    EndIf
    If cpxpos=lady(bug)\lpxpos And cpypos=lady(bug)\lpypos:quit=2:EndIf
  Next
Return

draw_board:
  DisplaySprite(4,0,0)                            ;draw background to clear the screen
  For y=1 To 13                                   
    For x=1 To 12
       bl=maze(x,y)
       DisplaySprite(bl,x*32,y*32)                ;display the maze tiles on the screen
     Next
  Next
Return

draw_bugs:                                        ;draw Lady bug depending on the direction she's moving
  For bug=1 To bugs 
   If lady(bug)\lx=-1:DisplayTransparentSprite(6,lady(bug)\lpx,lady(bug)\lpy):EndIf
   If lady(bug)\lx=1:DisplayTransparentSprite(7,lady(bug)\lpx,lady(bug)\lpy):EndIf
   If lady(bug)\ly=-1:DisplayTransparentSprite(8,lady(bug)\lpx,lady(bug)\lpy):EndIf
   If lady(bug)\ly=1:DisplayTransparentSprite(9,lady(bug)\lpx,lady(bug)\lpy):EndIf
  Next
    frmbee=frmbee+1                               ;draw Bee depending on the direction he's moving
    If frmbee>9:frmbee=0:EndIf
    If mm=1:DisplayTransparentSprite(frmbee+30,cpx,cpy):EndIf
    If mm=2:DisplayTransparentSprite(frmbee+40,cpx,cpy):EndIf
    If mm=3:DisplayTransparentSprite(frmbee+50,cpx,cpy):EndIf
    If mm=4 Or mm=0:DisplayTransparentSprite(frmbee+20,cpx,cpy):EndIf    
Return

draw_diz:                                          ;draw dizzy bee looping through all 3 frames
  diz=diz+1
  If diz>3:diz=1:EndIf
  DisplayTransparentSprite(11+diz,cpx-16,cpy-16)
Return

draw_credits:                                      ;draw final credits on the screen
  For tmp=0 To 480                                ;have bee fly from top to bottom
    DisplaySprite(4,0,0)
    text(40,45,"PROGRAMMER")
    text(40,70,"PAUL LEISCHOW")
    text(40,120,"GRAPHICS")
    text(40,145,"PAUL LEISCHOW")
    text(40,195,"AUDIO")
    text(40,220,"PETE ZILINSKI")
    text(40,270,"THANKS TO")
    text(40,295,"PAUL GERFEN")
    text(40,320,"FRED LABOUREUR")
    text(40,370,"COPYRIGHT")
    text(40,395,"REEL MEDIA PRODUCTIONS")
    frmbee=frmbee+1
    If frmbee>9:frmbee=0:EndIf                   ;loop through the 9 frames while he flys
    DisplayTransparentSprite(frmbee+20,15,tmp)    ;(looks like he's flapping)
    FlipBuffers()                                 ;flip screen buffer into view so we can see it
  Next
Return




DataSection                          ;maze data and movement data for Lady
level1:                               ;each level has 2 sets of maze data
Data.l 1,1,1,1,1,1,1,1,1,1,1,1
Data.l 1,3,5,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,2,5,1,1,5,2,2,5,1        ;1 = bush1
Data.l 1,5,2,5,5,5,5,5,5,2,5,1        ;2 = bush2
Data.l 1,5,2,5,2,2,2,2,5,2,5,1        ;3 = no flower (space)
Data.l 1,5,5,5,5,5,5,5,5,5,5,1        ;5 = flower 
Data.l 1,5,1,1,5,1,1,5,1,1,1,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,5,2,2,2,2,5,2,5,1
Data.l 1,5,2,5,5,5,5,5,5,2,5,1
Data.l 1,5,2,2,5,1,1,5,2,2,5,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,1,1,1,1,1,1,1,1,1,1,1
Data.l 74                             ;number of flowers to collect
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,1,0,0,8,0,0,8,0,0,2,0        ;movement data for Lady
Data.l 0,0,0,0,0,0,0,0,0,0,0,0        ;0 = no movement decision to be made
Data.l 0,0,0,1,6,0,0,6,2,0,0,0        ;1 = lady can move down or right
Data.l 0,0,0,0,0,0,0,0,0,0,0,0        ;2 = lady can move down or left
Data.l 0,7,0,6,8,0,0,8,6,0,3,0        ;3 = lady can move up or left
Data.l 0,0,0,0,0,0,0,0,0,0,0,0        ;4 = lady can move up or right
Data.l 0,7,0,8,6,0,0,6,8,0,2,0        ;5 = lady can move left or up or down 
Data.l 0,0,0,0,0,0,0,0,0,0,0,0        ;6 = lady can move up or left or right
Data.l 0,0,0,4,8,0,0,8,3,0,0,0        ;7 = lady can move right or up or down
Data.l 0,0,0,0,0,0,0,0,0,0,0,0        ;8 = lady can move down or left or right
Data.l 0,4,0,0,6,0,0,6,0,0,3,0 
Data.l 0,0,0,0,0,0,0,0,0,0,0,0 

;level 2
Data.l 1,1,1,1,1,1,1,1,1,1,1,1
Data.l 1,3,5,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,5,1,1,1,1,5,2,5,1
Data.l 1,5,2,5,5,5,5,5,5,2,5,1
Data.l 1,5,2,2,2,2,2,2,5,2,5,1
Data.l 1,5,5,5,5,5,5,2,5,5,5,1
Data.l 1,1,1,5,2,5,5,2,5,1,1,1
Data.l 1,5,5,5,2,5,5,5,5,5,5,1
Data.l 1,5,2,5,2,2,2,2,2,2,5,1
Data.l 1,5,2,5,5,5,5,5,5,2,5,1
Data.l 1,5,2,5,1,1,1,1,5,2,5,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,1,1,1,1,1,1,1,1,1,1,1
Data.l 71
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,1,0,8,0,0,0,0,8,0,2,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,0,0,4,0,0,0,0,5,0,0,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,4,0,8,0,8,2,0,7,0,3,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,1,0,5,0,4,6,0,6,0,2,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,0,0,7,0,0,0,0,2,0,0,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,4,0,6,0,0,0,0,6,0,3,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0

;level 3
Data.l 1,1,1,1,1,3,3,1,1,1,1,1
Data.l 1,3,5,5,1,3,3,1,5,5,5,1
Data.l 1,5,2,5,1,1,1,1,5,2,5,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,2,2,2,5,1,1,1,1,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,2,5,2,2,2,5,2,5,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,1,1,1,1,5,2,2,2,2,5,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,5,1,1,1,1,5,2,5,1
Data.l 1,5,5,5,1,3,3,1,5,5,5,1
Data.l 1,1,1,1,1,3,3,1,1,1,1,1
Data.l 67
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,1,0,2,0,0,0,0,1,0,2,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,7,0,6,0,0,8,0,6,0,3,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,7,0,0,8,0,6,0,8,0,2,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,4,0,0,6,8,0,0,6,0,5,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,1,0,8,0,6,0,0,8,0,5,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,4,0,3,0,0,0,0,4,0,3,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0

;level 4
Data.l 1,1,1,1,1,1,1,1,1,1,1,1
Data.l 1,3,5,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,5,2,2,2,2,2,2,5,1
Data.l 1,5,2,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,5,1,5,1,1,5,2,5,1
Data.l 1,5,2,5,1,5,5,1,5,5,5,1
Data.l 1,5,5,5,1,1,5,5,5,2,5,1
Data.l 1,5,2,5,1,5,5,1,5,5,5,1
Data.l 1,5,2,5,1,5,1,1,5,2,5,1
Data.l 1,5,2,5,5,5,5,5,5,5,5,1
Data.l 1,5,2,5,2,2,2,2,2,2,5,1
Data.l 1,5,5,5,5,5,5,5,5,5,5,1
Data.l 1,1,1,1,1,1,1,1,1,1,1,1
Data.l 74
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,1,0,8,0,0,0,0,0,0,2,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,0,0,7,0,8,0,0,8,0,5,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,0,0,0,0,4,2,0,7,0,5,0
Data.l 0,7,0,5,0,0,7,0,5,0,0,0
Data.l 0,0,0,0,0,1,3,0,7,0,5,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,0,0,7,0,6,0,0,6,0,5,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0
Data.l 0,4,0,6,0,0,0,0,0,0,3,0
Data.l 0,0,0,0,0,0,0,0,0,0,0,0

EndDataSection 
; ExecutableFormat=Windows
; UseIcon=D:\Documents and Settings\Administrateur\Bureau\Lady\lady.ico
; Executable=D:\Documents and Settings\Administrateur\Bureau\Lady\lady.exe
; DisableDebugger